/**
  * @file <loop-functions/example/ForagingLoopFunc.h>
  *
  * @author Antoine Ligot - <aligot@ulb.ac.be>
  *
  * @package ARGoS3-AutoMoDe
  *
  * @license MIT License
  */

#ifndef FORAGING_TWO_SPOTS_LOOP_FUNC
#define FORAGING_TWO_SPOTS_LOOP_FUNC

#include <regex>
#include <map>
#include <argos3/core/simulator/space/space.h>
#include <argos3/plugins/robots/e-puck/simulator/epuck_entity.h>
#include <argos3/plugins/simulator/entities/box_entity.h>
#include "../../../src/CoreLoopFunctions.h"

using namespace argos;

class ChocolateMission2LoopFunction: public CoreLoopFunctions {
  public:
    ChocolateMission2LoopFunction();
    ChocolateMission2LoopFunction(const ChocolateMission2LoopFunction& orig);
    virtual ~ChocolateMission2LoopFunction();

    virtual void Destroy();
    //virtual void Init(TConfigurationNode& t_tree);

    virtual argos::CColor GetFloorColor(const argos::CVector2& c_position_on_plane);
    virtual void PostExperiment();
    virtual void PostStep();
    virtual void Reset();
    virtual void Init(TConfigurationNode& t_tree);
    //UInt32  GetNumRobots();

    Real GetObjectiveFunction();

    CVector3 GetRandomPosition();


    //bool IsWithinTriangle(CVector2& c_point_q, CVector2& c_point_a, CVector2& c_point_b, CVector2& c_point_c);
    //Real AreaTriangle(CVector2& c_point_a, CVector2& c_point_b, CVector2& c_point_c);
    bool IsWithinRegion(CVector2& vCurrentPoint, Real m_fNestLimit);
    bool IsWithinCircle(CVector2 c_cEpuckPosition, CVector2& m_cCoordSpot, Real fRadius);
    //void Initialize();
    Real InnerRadious();
  


  private:
    Real fRadius;
    Real m_fRadius;
    Real m_fNestLimit;
    CVector2 m_cCoordSpot1;
    CVector2 m_cCoordSpot2;
    std::regex m_cRegex;
    

    //bool m_bInitializationStep;

    Real m_fObjectiveFunction;

    //UInt32 * m_punFoodData;
    std::map<std::string, UInt32> m_mapFoodData;

    UInt32 m_unNumberEdges;
   // UInt32 currentnumRobots;
    //UInt32 m_robotmin;

    CBoxEntity *pcWall;
    Real sidesize;

    //struct Point {
    //   Real x, y;
    //};


  // struct line {
   //   Point p1, p2;

  // };

  // Point *arena;


 public:
    //bool InsidePolygon(Point polygon[],int N,Point p);
   // Real InsidePolygon(Point *polygon,int n,Point p);
   // Real Angle2D(const Real x1, const Real y1, const Real x2, const Real y2);
   // bool Is_Inside(Point &point, Point points_list[]);
   // int Is_Left(Point &p0, Point &p1, Point &point);
  //  int Direction(Point a, Point b, Point c);
  //  bool OnLine(line l1, Point p);
    //bool IsIntersect(line l1, line l2);
    //bool CheckInside(Point poly[], int n, Point p);
    void RemoveRobot(int i);
    Real OuterRadius();
    //int min(int a, int b);
   // int max(int a, int b);
    //Real min(Real a, Real b);
    //Real max(Real a, Real b);


};

#endif